unit PulseGen;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, OleCtrls, DbOleCtl, DlsrLib_TLB;

type
  TForm1 = class(TForm)
    DriverLINXSR1: TDriverLINXSR;
    lblStatus: TLabel;
    cmdPulseGen: TButton;
    cmdStop: TButton;
    DriverLINXSR2: TDriverLINXSR;
    StaticText1: TStaticText;
    Button1: TButton;
    cmdSqWave: TButton;
    cmbDevNumber: TComboBox;
    Label1: TLabel;
    procedure cmdPulseGenClick(Sender: TObject);
    procedure cmdStopClick(Sender: TObject);
    procedure CloseDriverLINX(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure cmdSqWaveClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.cmdPulseGenClick(Sender: TObject);
begin
// use SR2 to generate the pulse on CT1

// first stop any potentially active task
with DriverLINXSR2 do begin

    Req_subsystem := DL_CT;
    Req_mode := DL_POLLED;
    Req_op := DL_STOP;
    Refresh;
end;
// set up a task to generate a pulse
with DriverLINXSR2 do begin
    Req_subsystem := DL_CT;
    Req_mode := DL_POLLED;
    Req_op := DL_START;
    Evt_Tim_type := DL_RATEEVENT;
    Evt_Tim_rateChannel := 1;
    Evt_Tim_rateMode := DL_PULSEGEN;
    Evt_Tim_rateClock := DL_TCnm1;
    // the 16bit C/T channels can cascade internally
    // TCnm1 means "Terminal count of the N-1 counter, or
    // the counter in front of me (I'm the N counter)
    //Evt_Tim_rateClock := DL_EXTERNAL; // or feed it in externally
    Evt_Tim_rateGate := 9;  //dl_hiedgegaten;
    Evt_Tim_ratePeriod := 1; // delay from the gating edge untill start of pulse
    Evt_Tim_rateOnCount := 100; // active low duration of pulse
    // Total period will be delay + OnCount properties
    // delay must be at least 1 tic
    Evt_Tim_ratePulses := 0;    // 0 = continuous; 1 = one shot, must be rearmed for each new pulse
    Evt_Tim_rateOutput := CT_Output_LoToggled; // active low pulse
    {
      Best to use active low pulse......the default state of output
      pin of a CT is logic 1 (has pull up resistor).  If wanting
      to use active high pulses, the state of the CT output will not
      go low until the task is armed....followed by your pulses.  As
      soon as task is stopped, the output will be pulled high again.
      You application must be designed to tolerate this.
    }
    //Evt_Tim_rateOutput := CT_Output_HiToggled; // active high pulse
    Evt_Str_type := DL_NULLEVENT;
    Evt_Stp_type := DL_NULLEVENT;
    Sel_buf_N := 0;
    Sel_chan_N := 0;
    Refresh;
end;
  if (DriverLINXSR2.Res_result <> DL_NoErr) then

    lblStatus.caption := DriverLINXSR2.Message
  else
  lblStatus.Caption := 'Apply rising edge at gate of CT1....';
 

end;

procedure TForm1.cmdStopClick(Sender: TObject);
begin
with DriverLINXSR1 do begin

    Req_subsystem := DL_CT;
    Req_mode := DL_POLLED;
    Req_op := DL_STOP;
    Refresh;
end;
  lblStatus.caption := DriverLINXSR1.Message;

with DriverLINXSR2 do begin

    Req_subsystem := DL_CT;
    Req_mode := DL_POLLED;
    Req_op := DL_STOP;
    Refresh;
end;

end;

procedure TForm1.CloseDriverLINX(Sender: TObject);
begin
DriverLINXSR1.Req_DLL_name := '';
DriverLINXSR2.Req_DLL_name := '';
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
// initialize hardware and first SR object

DriverLINXSR1.Req_DLL_name := 'kpci3100';
DriverLINXSR1.Req_device := cmbdevnumber.ItemIndex; // same as the selection for us
DriverLINXSR1.Req_mode := DL_OTHER;
DriverLINXSR1.Req_op := DL_INITIALIZE;
DriverLINXSR1.Req_subsystem := DL_DEVICE;
DriverLINXSR1.Refresh();


lblStatus.caption := DriverLINXSR1.Message;

// set second SR control to same driver name as first
// control since they are for the same physical board

DriverLINXSR2.Req_DLL_name := DriverLINXSR1.Req_DLL_name;

// set focus back to our form
Form1.SetFocus();
end;

procedure TForm1.cmdSqWaveClick(Sender: TObject);
begin
  // use SR1 to generate square wave on CT0 for time base signal
with DriverLINXSR1 do begin

    Req_subsystem := DL_CT;
    Req_mode := DL_POLLED;
    Req_op := DL_START;
    Evt_Tim_type := DL_RATEEVENT;
    Evt_Tim_rateChannel := 0;
    Evt_Tim_rateMode := DL_SQWAVE;
    Evt_Tim_rateClock := DL_INTERNAL1;
    Evt_Tim_rateGate := DL_NOCONNECT;
    Evt_Tim_ratePeriod := DriverLINXSR1.DLSecs2Tics(DL_INTERNAL1,1/10000);
    Evt_Tim_rateOnCount := 0;
    Evt_Tim_ratePulses := 0;
    Evt_Tim_rateOutput := CT_Output_LoToggled;
    Evt_Str_type := DL_NULLEVENT;
    Evt_Stp_type := DL_NULLEVENT;
    Sel_buf_N := 0;
    Sel_chan_N := 0;
    Refresh;
end;
  lblStatus.caption := DriverLINXSR1.Message;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
// load combo box with legal values for device number, e.g., 0 - 5

cmbdevnumber.Items.Add('0');
cmbdevnumber.Items.Add('1');
cmbdevnumber.Items.Add('2');
cmbdevnumber.Items.Add('3');
cmbdevnumber.Items.Add('4');
cmbdevnumber.Items.Add('5');
cmbdevnumber.ItemIndex := 0;  // set it equal to first entry

end;

end.
